<?php
/*
 * Template Name: Package
 */

get_header();
the_post();
$data = get_fields();



?>

<div class="block-section">
    <div class="container">
        <div class="text-center">
            <h1 class="mb-4"><?php the_title(); ?></h1>
        </div>
        <div class="slider-image mb-5">
            <div class="owl-carousel">
                <?php foreach ($data['slider'] as $k => $item) : ?>
                    <div class="item">
                        <img src="<?= $item['url']; ?>">
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <div class="clearfix pb-lg-5 pb-4"></div>


        <div class="row align-items-stretch mb-4">
            <?php foreach ($data['items'] as $k => $item) : ?>
                <div class="col-lg-4 mb-lg-0 mb-4 d-flex align-items-stretch">
                    <div class="card border-0 shadow overflow-hidden w-100">
                        <div class="img-view mb-2">
                            <div class="img-placeholder">
                                <div class="img-show" style="background-image:url('<?= $item['image']['url']; ?>')"></div>
                            </div>
                        </div>
                        <div class="text-center px-4 pb-4">
                            <div class="h2 mb-0 text-seconary"><?= $item['name']; ?></div>
                            <div><?= $item['caption']; ?></div>
                            <div class="h4 mb-1"><?= $item['caption_hilight']; ?></div>
                            <div class="h1x text-primary"><strong><?= $item['pricing']; ?></strong></div>
                            <div class="text-muted"><?= $item['note']; ?></div>
                        </div>
                        <!-- <img src="" class="w-100"> -->
                    </div>
                </div>
            <?php endforeach; ?>

            <div class="col-lg-4 mb-lg-0 mb-4 d-flex align-items-stretch">
                <div class="card border-0 d-flex align-items-center justify-content-center shadow overflow-hidden w-100" style="min-height:300px">
                    <div class="h2 text-muted text-center px-3 py-5 py-lg-0">แล้วพบกับ<br>โปรโมชั่นใหม่ เร็วๆ นี้</div>
                </div>
            </div>
        </div>

    </div>
</div>




<?php get_footer();
