<?php
ini_set('date.timezone','Asia/Shanghai');
error_reporting(E_ERROR);

require_once VENDOR_PATH."Wxpay/lib/WxPay.Api.php";
require_once VENDOR_PATH.'Wxpay/lib/WxPay.Notify.php';
require_once 'log.php';

//初始化日志
$logHandler= new CLogFileHandler("../logs/".date('Y-m-d').'.log');
$log = Log::Init($logHandler, 15);

class PayNotifyCallBack extends WxPayNotify
{
	//查询订单
	public function Queryorder($transaction_id)
	{
		$input = new WxPayOrderQuery();
		$input->SetTransaction_id($transaction_id);
		$result = WxPayApi::orderQuery($input);
		Log::DEBUG("query:" . json_encode($result));
		if(array_key_exists("return_code", $result)
			&& array_key_exists("result_code", $result)
			&& $result["return_code"] == "SUCCESS"
			&& $result["result_code"] == "SUCCESS")
		{
			return true;
		}
		return false;
	}

	//重写回调处理函数
	public function NotifyProcess($data, &$msg)
	{
		Log::DEBUG("call back:" . json_encode($data));
		$notfiyOutput = array();

		if(!array_key_exists("transaction_id", $data)){
			$msg = "输入参数不正确";
			return false;
		}
		//查询订单，判断订单真实性
		if(!$this->Queryorder($data["transaction_id"])){
			$msg = "订单查询失败";
			return false;
		}
		$out_trade_no = $data['out_trade_no'];
		$trade_no = $data["transaction_id"];


		if(substr($out_trade_no, 0,1)=='s'){
		    getAvlBox($out_trade_no,'member'); //分配格子
// 		    check_baocang($out_trade_no);
		}

		update_pay_success($out_trade_no, $trade_no); // 修改订单支付状态
		update_pay_type($out_trade_no, 'wxpay');
		
		if(substr($out_trade_no, 0,1)=='c'){
		    member_charge($out_trade_no);
		}



		return true;
	}
}

// Log::DEBUG("begin notify");
// $notify = new PayNotifyCallBack();
// $notify->Handle(false);
