<?php

namespace Admin\Model;
use Think\Model;

/**
 * 柜机格子模型
 */
class MachineBoxModel extends Model{

    protected $_validate = array(
    	array('num', 'require', 'No. cannot be empty', self::MUST_VALIDATE , 'regex', self::MODEL_BOTH),
    	array('num', 'checkNum', 'Only numbers can be filled in the cell number', self::MUST_VALIDATE , 'callback', self::MODEL_BOTH),
    	array('mac_id', 'checkMac', 'Please select the machine', self::MUST_VALIDATE , 'callback', self::MODEL_BOTH),
    );

    protected $_auto = array(
        array('create_time', NOW_TIME, self::MODEL_INSERT),
        array('update_time', NOW_TIME, self::MODEL_BOTH),
    	array('status', '1', self::MODEL_BOTH),
    );


    /* 检查格子编号 */
    public function checkNum($value){
    	return is_numeric($value);

    }

    /* 检查格子编号是否已存在 */
    public function isExsit($value){
    	return is_numeric($value);

    }

    /* 检查机柜编号 */
    public function checkMac($value){
    	return !empty($value);

    }
    
    
    //获取格子锁板、编号
    public function getBoxInfo($mac_id,$boxes){
        $map['mac_id'] = $mac_id;
        $map['num'] = array('in',$boxes);
         
        $lists = $this->where($map)->field('addr,door')->select();
    
        return $lists;
    }

}
