<?php
// +----------------------------------------------------------------------
// | OneThink [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2013 http://www.onethink.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: 麦当苗儿 <zuojiazi@vip.qq.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------

namespace Admin\Controller;
use Admin\Model\AuthRuleModel;
use Admin\Model\AuthGroupModel;

/**
 * 后台管理员控制器
 * @author 麦当苗儿 <zuojiazi@vip.qq.com>
 */
class ManagerController extends AdminController {

    /**
     * 管理员列表
     */
    public function index(){
        $keywords       =   I('keywords');
        $map['status']  =   array('egt',0);
        if(!empty($keywords)){
            $map['username|nickname|mobile|email']    =   array('like', '%'.(string)$keywords.'%');
        }

        $list   = $this->lists('Manager', $map);
        int_to_string($list);
        $this->assign('_list', $list);
        $this->assign('keywords', $keywords);
        $this->meta_title = 'Manager List';
        $this->display();
    }
    

    /**
     * 修改管理员状态
     */
    public function changeStatus($method=null){
        $ids = array_unique((array)I('ids',0));
        if( in_array(C('USER_ADMINISTRATOR'), $ids)){
            $this->error("Do not allow this to be done to a super administrator!");
        }
        $ids = is_array($ids) ? implode(',',$ids) : $ids;
        if ( empty($ids) ) {
            $this->error('Please select the data to operate on!');
        }
        $map['uid'] =   array('in',$ids);
        switch ( strtolower($method) ){
            case 'forbiduser':
                $this->forbid('Manager', $map );
                break;
            case 'resumeuser':
                $this->resume('Manager', $map );
                break;
            case 'deleteuser':
                $this->delete('Manager', $map );
                break;
            default:
                $this->error('parameter error');
        }
    }

    /*
     * 新增管理员
     */
    public function add(){
        if(IS_POST){
            $model = D('Manager');
            if($data=$model->create()){
                $uid = $model->add($data);
                if($uid){
                    //管理员授权
                    $this->addToGroup($uid);
                    $this->success('add manager succeed',U('index'));
                }else{
                    $this->error('add manager failed');
                }
            }else{
                $message = $model->getError();
                $this->error($message);
            }

        } else {
            $auth_groups    =   D('AuthGroup')->getGroups();
            $this->assign('auth_groups',$auth_groups);
            $this->meta_title = 'New Manager';
            $this->display();
        }
    }
    
    /*
     * 编辑管理员
     */
    public function edit(){
        if(IS_POST){
            $model = D('Manager');
            if($data=$model->create()){
                $status = $model->save($data);
                if($status){
                    //管理员授权
                    $this->addToGroup($data['uid']);
                    $this->success('edit manager succeed',U('index'));
                }else{
                    $this->error('edit manager failed');
                }
            }else{
                $message = $model->getError();
                $this->error($message);
            }
    
        } else {
            $uid = I('id',0);
            $info = $this->getInfo();
            $auth_groups    =   D('AuthGroup')->getGroups();
            $user_groups    =   AuthGroupModel::getUserGroup($uid);
            $ids = array();
            foreach ($user_groups as $value){
                $ids[]      =   $value['group_id'];
            }
            $this->assign('user_groups',implode(',',$ids));
            $this->assign('auth_groups',$auth_groups);
            $this->assign('info',$info);
            $this->meta_title = 'Edit Manager';
            $this->display('add');
        }
    }
    
    
    
    /*
     * 用户授权
     */
    protected function addToGroup($uid=0){
        $gid=I('group_id');
        $AuthGroup = D('AuthGroup');
        if(is_numeric($uid)){
            if ( is_administrator($uid) ) {
                return array('status'=>-1,'info'=>'该用户为超级管理员');
            }
            if( !M('Manager')->where(array('uid'=>$uid))->find() ){
                return array('status'=>-1,'info'=>'用户不存在');
            }
        }
    
        if( $gid && !$AuthGroup->checkGroupId($gid)){
            return array('status'=>-1,'info'=>$AuthGroup->error);
        }
        if ( $AuthGroup->addToGroup($uid,$gid) ){
            return array('status'=>1,'info'=>'用户授权成功');
        }else{
            return array('status'=>-1,'info'=>$AuthGroup->getError());
        }
    }


    /*
     * 管理员Edit personal information
    */
    public function update(){
        if(IS_POST){
            $model = D('Manager');
            $info = $model->getUserInfo(UID);
            $oldpwd = pwd_md5(I('oldpassword',''),AUTH_KEY);
            if($oldpwd!=$info['password'])
                $this->error('The current password is incorrect');
            if($data=$model->create()){
                $status = $model->save($data);
                if($status){
                    $this->success('Edit personal information succeeded',U('index'));
                }else{
                    $this->error('Failure to edit personal information');
                }
            }else{
                $message = $model->getError();
                $this->error($message);
            }
    
        } else {
            $info = D('Manager')->getUserInfo(UID);
            $this->assign('info',$info);
            $this->meta_title = 'Edit personal information';
            $this->display('update');
        }
    }

}