<?php

namespace Admin\Controller;

/*
 * 柜机
 */
class MachineController extends AdminController {

    /**
     * 列表
     */
    public function index(){
        $keywords       =   I('keywords');
        $map['status'] = array('in','1,0,-1');
        if(!empty($keywords)){
            $map['title|serial_no|address']    =   array('like', '%'.(string)$keywords.'%');
        }

        $list   = $this->lists(CONTROLLER_NAME, $map);
        int_to_string($list);
        $this->assign('_list', $list);
        $this->assign('keywords', $keywords);
        $this->meta_title = 'Machine List';
        $this->display('index');
    }


    /*
     * 编辑柜机
    */
    public function edit(){
    	if(IS_POST){
    		clearCache();
    		$this->save(CONTROLLER_NAME,'index');

    	} else {
    		$info = $this->getInfo(CONTROLLER_NAME);
    		$agents = $this->lists('Agent',array('status'=>1),'id desc',true,10000);
    		$merchants = $this->lists('Merchant',array('status'=>1),'id desc',true,10000);
    		$factorys = $this->lists('Factory',array('status'=>1),'id desc',true,10000);

    		$this->assign('info',$info);
    		$this->assign('agents',$agents);
    		$this->assign('merchants',$merchants);
    		$this->assign('factorys',$factorys);
    		$this->meta_title = empty($info)? 'New machine':'Edit machine' ;
    		$this->display();
    	}
    }


    /**
     * 格子列表
     */
    public function box($mac_id=0){
    	$map['status'] = array('in','1,0,-1');
    	$map['mac_id'] = $mac_id;

    	$list   = $this->lists('MachineBox', $map);
    	int_to_string($list);
    	$this->assign('_list', $list);
    	$this->meta_title = 'Box List';
    	$this->display('box');
    }

    /*
     * 编辑格子
    */
    public function box_edit(){
    	if(IS_POST){
    		$mac_id = I('mac_id',0);
    		$this->save('MachineBox','box?mac_id='.$mac_id);

    	} else {
    		$info = $this->getInfo('MachineBox');
    		$types = getBoxType();

    		$this->assign('info',$info);
    		$this->assign('types',$types);
    		$this->meta_title = empty($info)? 'New box':'Edit box' ;
    		$this->display();
    	}
    }


    /**
     * 广告列表
     */
    public function ad($mac_id=0){
    	$map['status'] = array('in','1,0');
    	$map['mac_id'] = $mac_id;
    	$keywords = I('keywords','');

    	$list   = $this->lists('Ad', $map);
    	int_to_string($list);
    	$this->assign('_list', $list);
    	$this->assign('keywords', $keywords);
    	$this->meta_title = 'Ad list';
    	$this->display('ad');
    }

    /*
     * 广告格子
    */
    public function ad_edit(){
    	if(IS_POST){
    		$mac_id = I('mac_id',0);
    		$this->save('Ad','ad?mac_id='.$mac_id);

    	} else {
    		$info = $this->getInfo('Ad');

    		$this->assign('info',$info);
    		$this->meta_title = empty($info)? 'New ad':'Edit ad' ;
    		$this->display();
    	}
    }



}