<?php
// +----------------------------------------------------------------------
// | OneThink [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2013 http://www.onethink.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: 麦当苗儿 <zuojiazi@vip.qq.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------

namespace Admin\Controller;

use Common\Model\MemberModel;
/**
 * 后台会员控制器
 * @author 麦当苗儿 <zuojiazi@vip.qq.com>
 */
class MemberController extends AdminController {

    /**
     * 列表
     */
    public function index(){
        $p = I('p',1);
        $demo = 1;
        $keywords       =   I('keywords');
        $map['status']  =   array('egt',0);
        
        $start_date = I('start_date');
        $end_date = I('end_date');
        if(!empty($start_date)&&!empty($end_date)){
            $start_date = strtotime($start_date);
            $end_date = strtotime($end_date)+3600*24;
            $map['regtime']    =   array(array('EGT',$start_date),array('ELT',$end_date),'and');
        }
        if(!empty($keywords)){
            $map['username|mobile']    =   array('like', '%'.(string)$keywords.'%');
        }
        if(UID!=26){
            $map['is_fault'] = 0;
            $demo = 0;
        }

        $list   = $this->lists('Member', $map, 'regtime desc');
        int_to_string($list);
        $this->assign('_list', $list);
        $this->assign('keywords', $keywords);
        $this->assign('p', $p);
        $this->assign('demo', $demo); //是为演示数据
        $this->meta_title = 'Member List';
        $this->display();
    }


    /**
     * 修改会员状态
     */
    public function changeStatus($method=null){
        $ids = array_unique((array)I('ids',0));

        $ids = is_array($ids) ? implode(',',$ids) : $ids;
        if ( empty($ids) ) {
            $this->error('请选择要操作的数据!');
        }
        $map['uid'] =   array('in',$ids);
        switch ( strtolower($method) ){
            case 'forbiduser':
                $this->forbid('Member', $map );
                break;
            case 'resumeuser':
                $this->resume('Member', $map );
                break;
            case 'deleteuser':
                $this->delete('Member', $map );
                break;
            default:
                $this->error('参数非法');
        }
    }


    /*
     * 后台给会员充值
     */
    public function charge($id=0) {
        if(IS_POST){
            $uid = I('uid',0);
            $money = I('money',0);
            $note = I('note','');
            $token = I('token','');


            $local_token = S('form_token');
            if($token==$local_token){
                $this->error('请勿重复提交');
            }else{
                S('form_token',$token);
            }

            if(!is_numeric($money)){
                $this->error('充值金额有误');
            }
            $order['out_trade_no'] = 'c'.$uid.time().rand(10000, 99999);
            $order['userid']=$uid;
            $order['pay_fee'] = $money;
            $order['createtime'] = time();
            $order['source'] = 'admin';
            $order['pay_type'] = 'admin';
            $order['pay_status'] = 1;
            $order['pay_time'] = time();
            $order['note'] = $note;

            M('OrderCharge')->add($order);

            $res = member_charge($order['out_trade_no']);
            if($res){
                $this->success('充值成功');
            }else{
                $this->error('充值失败');
            }

        } else {
            $obj_mem = new MemberModel();
            $info = $obj_mem->getInfoById($id);
            $this->assign('info',$info);
            $this->assign('token',md5(time()));
            $this->meta_title = '会员充值';
            $this->display();
        }
    }
    
    
    /**
     * 优惠券列表
     */
    public function coupon($userid=0){
        $map['status']  =   array('egt',0);
        $map['userid']  =   $userid;

        $list   = $this->lists('MemberCoupon', $map);
        int_to_string($list);
        $this->assign('_list', $list);
        $this->meta_title = '优惠券列表';
        $this->display();
    }

}